import constants from '../../config.js';
/**
  * @param {number} year
  */
async function getDonutContent(year) {
  const url = `${constants.config.apiUrl}/donut-chart/${year}`;
  return fetch(url, {
    method: 'GET',
    headers: {
      'Content-Type': 'application/json'
    }
  });
  /* return new Promise((resolve, reject) => {
    resolve(
      [
        "Auvergne-Rhône-Alpes",
        "Hauts-de-France",
        "Provence-Alpes-Côte d'Azur",
        "Grand Est",
        "Occitanie",
        "Normandie",
        "Nouvelle-Aquitaine",
        "Centre-Val de Loire",
        "Corse",
        "Bourgogne-Franche-Comté",
        "Bretagne",
        "Pays de la Loire",
        "Île-de-France",
        "Guadeloupe",
        "Martinique",
        "Guyane",
        "La Réunion",
        "Mayotte",
        "Nouvelle Calédonie"
      ].map((x) => ({region: x, occurences: Math.round(Math.random() * 300)}))
    );
  });*/
}

const getTimesSeries = () => {
  const url = `${constants.config.apiUrl}/timeseries?page=1`;
  return fetch(url, {
    method: 'GET',
    headers: {
      'Content-Type': 'application/json'
    }
  });
}

async function fetchBarChartData(formData) {
  const url = `${constants.config.apiUrl}/bar-chart/${formData.startDate}/${formData.endDate}/${formData.granularity}?page=1`;
  return fetch(url, {
    method: 'GET',
    headers: {
      'Content-Type': 'application/json'
    }
  });
}

export default {
  getDonutContent,
  getTimesSeries,
  fetchBarChartData
};
