<?php

namespace App\Tests\Api;

use ApiPlatform\Symfony\Bundle\Test\ApiTestCase;

class SalesTest extends ApiTestCase
{
    public function testGetTimeSeries(): void
    {
        $client = static::createClient()->request('GET', '/api/timeseries');

        $this->assertResponseStatusCodeSame(200);

        // Décoder le contenu JSON
        $data = json_decode($client->getContent(), true);

        # print_r($client->getContent());

        $this->assertJsonContains([
            [
                'month' => 1,
                'year' => 2020,
                'averagePrice' => 1000,
            ],
            [
                'month' => 2,
                'year' => 2021,
                'averagePrice' => 1000,
            ],
        ]);
    }

    public function testGetBarChartDataMonth(): void
    {
        $client = static::createClient()->request('GET', '/api/bar-chart/2018-06-01/2019-12-31/month');

        #print_r($client->getContent());
        $this->assertResponseStatusCodeSame(200);
        $this->assertJsonContains([]);
    }

    public function testGetBarChartDataMonth2(): void
    {
        $client = static::createClient()->request('GET', '/api/bar-chart/2020-01-01/2020-12-31/month');

        #print_r($client->getContent());
        $this->assertResponseStatusCodeSame(200);
        $this->assertJsonContains([
            [
                'date' => '2020-01',
                'occurrences' => 1
            ]
        ]);

    }

    public function testGetBarChartDataMonth3(): void
    {
        $client = static::createClient()->request('GET', '/api/bar-chart/2020-01-01/2022-12-31/month');

        #print_r($client->getContent());
        $this->assertResponseStatusCodeSame(200);
        $this->assertJsonContains([
            [
                'date' => '2020-01',
                'occurrences' => 1
            ],
            [
                'date' => '2021-02',
                'occurrences' => 1
            ],
        ]);

    }

    public function testGetBarChartDataYear(): void
    {
        $client = static::createClient()->request('GET', '/api/bar-chart/2018-06-01/2019-12-31/year');

        #print_r($client->getContent());
        $this->assertResponseStatusCodeSame(200);
        $this->assertJsonContains([]);

    }

    public function testGetBarChartDataYear2(): void
    {
        $client = static::createClient()->request('GET', '/api/bar-chart/2020-01-01/2020-12-31/year');

        #print_r($client->getContent());
        $this->assertResponseStatusCodeSame(200);
        $this->assertJsonContains([
            [
                'date' => '2020',
                'occurrences' => 1
            ]
        ]);

    }

    public function testGetBarChartDataYear3(): void
    {
        $client = static::createClient()->request('GET', '/api/bar-chart/2020-01-01/2022-12-31/year');

        #print_r($client->getContent());
        $this->assertResponseStatusCodeSame(200);
        $this->assertJsonContains([
            [
                'date' => '2020',
                'occurrences' => 1
            ],
            [
                'date' => '2021',
                'occurrences' => 1
            ],
        ]);

    }

    public function testGetBarChartDataDay(): void
    {
        $client = static::createClient()->request('GET', '/api/bar-chart/2018-06-01/2019-12-31/day');

        #print_r($client->getContent());
        $this->assertResponseStatusCodeSame(200);
        $this->assertJsonContains([]);

    }

    public function testGetBarChartDataDay2(): void
    {
        $client = static::createClient()->request('GET', '/api/bar-chart/2020-01-01/2020-12-31/day');

        #print_r($client->getContent());
        $this->assertResponseStatusCodeSame(200);
        $this->assertJsonContains([
            [
                'date' => '2020-01-01',
                'occurrences' => 1
            ]
        ]);

    }

    public function testGetBarChartDataDay3(): void
    {
        $client = static::createClient()->request('GET', '/api/bar-chart/2020-01-01/2022-12-31/day');

        #print_r($client->getContent());
        $this->assertResponseStatusCodeSame(200);
        $this->assertJsonContains([
            [
                'date' => '2020-01-01',
                'occurrences' => 1
            ],
            [
                'date' => '2021-02-01',
                'occurrences' => 1
            ],
        ]);

    }

    public function testGetDonutChartData(): void
    {
        $client = static::createClient()->request('GET', '/api/donut-chart/2022');

        $this->assertResponseStatusCodeSame(200);

        #print_r($client->getContent());
        $this->assertJsonContains([]);
    }

    public function testGetDonutChartData2(): void
    {
        $client = static::createClient()->request('GET', '/api/donut-chart/2021');

        $this->assertResponseStatusCodeSame(200);

        #print_r($client->getContent());
        $this->assertJsonContains([
            [
                'region' => 'Normandie',
                'occurrences' => 1
            ]
        ]);
    }

    public function testGetDonutChartData3(): void
    {
        $client = static::createClient()->request('GET', '/api/donut-chart/2020');

        $this->assertResponseStatusCodeSame(200);

        #print_r($client->getContent());
        $this->assertJsonContains([
            [
                'region' => 'Auvergne-Rhône-Alpes',
                'occurrences' => 1
            ]
        ]);
    }

    public function testGetDonutChartData4(): void
    {
        $client = static::createClient()->request('GET', '/api/donut-chart/2016');

        $this->assertResponseStatusCodeSame(404);

    }
}
