<?php

namespace App\DataFixtures;

use App\Entity\Sale;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Persistence\ObjectManager;

class AppFixtures extends Fixture
{
    public function load(ObjectManager $manager): void
    {
        $sale = new Sale();
        $sale->setDate(new \DateTimeImmutable('2020-01-01'));
        $sale->setAmount(100000);
        $sale->setRegion('Auvergne-Rhône-Alpes');
        $sale->setSurface(100);

        $manager->persist($sale);

        $sale = new Sale();
        $sale->setDate(new \DateTimeImmutable('2021-02-01'));
        $sale->setAmount(200000);
        $sale->setRegion('Normandie');
        $sale->setSurface(200);

        $manager->persist($sale);

        $manager->flush();
    }
}
