/*
 * Decompiled with CFR 0.152.
 */
package collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Stack;

public class BinarySearchTree<E extends Comparable<E>>
implements Collection<E> {
    private Noeud racine;
    private int size = 0;

    @Override
    public boolean add(E e) {
        Objects.requireNonNull(e);
        if (this.racine == null) {
            this.racine = new Noeud(this, e);
            ++this.size;
            return true;
        }
        Noeud cur = this.racine;
        Noeud parent = null;
        int cmp = 0;
        while (cur != null) {
            parent = cur;
            cmp = e.compareTo(cur.cle);
            if (cmp < 0) {
                cur = cur.gauche;
                continue;
            }
            if (cmp > 0) {
                cur = cur.droit;
                continue;
            }
            return false;
        }
        if (cmp < 0) {
            parent.gauche = new Noeud(this, e);
        } else {
            parent.droit = new Noeud(this, e);
        }
        ++this.size;
        return true;
    }

    private Noeud findNode(E e) {
        Noeud cur = this.racine;
        while (cur != null) {
            int cmp = e.compareTo(cur.cle);
            if (cmp == 0) {
                return cur;
            }
            if (cmp < 0) {
                cur = cur.gauche;
                continue;
            }
            cur = cur.droit;
        }
        return null;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        try {
            Comparable e = (Comparable)o;
            return this.findNode(e) != null;
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    @Override
    public boolean remove(Object o) {
        Noeud child;
        if (o == null) {
            return false;
        }
        try {
            Comparable comparable = (Comparable)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        Comparable key = (Comparable)o;
        Noeud parent = null;
        Noeud cur = this.racine;
        while (cur != null && !cur.cle.equals(key)) {
            parent = cur;
            if (key.compareTo(cur.cle) < 0) {
                cur = cur.gauche;
                continue;
            }
            cur = cur.droit;
        }
        if (cur == null) {
            return false;
        }
        if (cur.gauche != null && cur.droit != null) {
            Noeud succParent = cur;
            Noeud succ = cur.droit;
            while (succ.gauche != null) {
                succParent = succ;
                succ = succ.gauche;
            }
            cur.cle = succ.cle;
            parent = succParent;
            cur = succ;
        }
        Noeud noeud = child = cur.gauche != null ? cur.gauche : cur.droit;
        if (parent == null) {
            this.racine = child;
        } else if (parent.gauche == cur) {
            parent.gauche = child;
        } else {
            parent.droit = child;
        }
        --this.size;
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Stack<Noeud> st;
            {
                this.st = this.init(BinarySearchTree.this.racine);
            }

            private Stack<Noeud> init(Noeud r) {
                Stack<Noeud> s = new Stack<Noeud>();
                Noeud c = r;
                while (c != null) {
                    s.push(c);
                    c = c.gauche;
                }
                return s;
            }

            @Override
            public boolean hasNext() {
                return !this.st.isEmpty();
            }

            @Override
            public E next() {
                Noeud n = this.st.pop();
                Object res = n.cle;
                Noeud c = n.droit;
                while (c != null) {
                    this.st.push(c);
                    c = c.gauche;
                }
                return res;
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.racine = null;
        this.size = 0;
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.size];
        int i = 0;
        for (Comparable e : this) {
            arr[i++] = e;
        }
        return arr;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean ch = false;
        for (Comparable e : c) {
            ch |= this.add((E)e);
        }
        return ch;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ch = false;
        for (Object o : c) {
            ch |= this.remove(o);
        }
        return ch;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList<Comparable> del = new ArrayList<Comparable>();
        for (Comparable e : this) {
            if (c.contains(e)) continue;
            del.add(e);
        }
        for (Comparable e : del) {
            this.remove(e);
        }
        return !del.isEmpty();
    }

    private static class Noeud {
        E cle;
        Noeud gauche;
        Noeud droit;
        final /* synthetic */ BinarySearchTree this$0;

        Noeud(E k) {
            this.this$0 = var1_1;
            this.cle = k;
        }
    }
}

