/*
 * Decompiled with CFR 0.152.
 */
package collection;

import collection.BinarySearchTree;
import collection.RedBlackTree;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;

public class Benchmark {
    private static final Random RNG = new Random(12345L);

    public static void main(String[] args) throws Exception {
        int[] ns = new int[]{1000, 2000, 5000, 10000, 20000, 50000};
        int reps = 5;
        String outFile = "benchmark_results.csv";
        try (PrintWriter pw = new PrintWriter(new FileWriter(outFile));){
            pw.println("structure,scenario,n,phase,avg_millis");
            for (String structure : Arrays.asList("ABR", "ARN")) {
                for (String scenario : Arrays.asList("random", "ascending")) {
                    for (int n : ns) {
                        long insertSum = 0L;
                        long searchSum = 0L;
                        for (int r = 0; r < reps; ++r) {
                            ArrayList<Integer> keys = new ArrayList<Integer>();
                            for (int i = 0; i < n; ++i) {
                                keys.add(i);
                            }
                            if (scenario.equals("random")) {
                                Collections.shuffle(keys, new Random(RNG.nextLong()));
                            }
                            Collection<Integer> tree = structure.equals("ARN") ? new RedBlackTree() : new BinarySearchTree();
                            long t0 = System.nanoTime();
                            for (Integer k : keys) {
                                tree.add(k);
                            }
                            long t1 = System.nanoTime();
                            long insertMs = t1 - t0;
                            insertSum += insertMs;
                            long t2 = System.nanoTime();
                            for (int x = 0; x < 2 * n; ++x) {
                                tree.contains(x);
                            }
                            long t3 = System.nanoTime();
                            long searchMs = t3 - t2;
                            searchSum += searchMs;
                        }
                        pw.printf("%s,%s,%d,insert,%.2f%n", structure, scenario, n, (double)insertSum / (double)reps);
                        pw.printf("%s,%s,%d,search,%.2f%n", structure, scenario, n, (double)searchSum / (double)reps);
                        pw.flush();
                        System.out.printf("Done %s %s n=%d%n", structure, scenario, n);
                    }
                }
            }
        }
        System.out.println("Wrote results to " + outFile);
    }
}

