package collection;

import static org.junit.jupiter.api.Assertions.assertDoesNotThrow;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;

public class BenchmarkTest {

  private static final String[] FILES = { "ABR_insert.csv", "ABR_search.csv", "ARN_insert.csv",
      "ARN_search.csv" };

  @AfterAll
  static void cleanup() {
    // Supprime les fichiers créés après le test
    for (String fileName : FILES) {
      File f = new File(fileName);
      if (f.exists()) {
        f.delete();
      }
    }
  }

  @Test
  void testBenchmarkCreatesCsvFiles() throws Exception {
    // Lance le benchmark
    Benchmark.main(new String[] {});

    // Vérifie que tous les fichiers existent
    for (String fileName : FILES) {
      File f = new File(fileName);
      assertTrue(f.exists(), "Le fichier " + fileName + " doit exister");
    }
  }

  @Test
  void testCsvHeaderAndScenario() throws Exception {
    Benchmark.main(new String[] {});

    // Vérifie le contenu d'un des fichiers, par exemple ABR_insert.csv
    File file = new File("ABR_insert.csv");
    try (BufferedReader reader = new BufferedReader(new FileReader(file))) {
      // Premier ligne = en-tête
      String header = reader.readLine();
      assertEquals("n,1000,2000,5000,10000,20000,50000", header);

      // Deuxième ligne = premier scénario
      String scenarioLine = reader.readLine();
      assertTrue(scenarioLine.startsWith("ASCENDANT") || scenarioLine.startsWith("ALEATOIRE"),
          "La ligne doit commencer par un scénario");
    }
  }

  @Test
  void testBenchmarkDoesNotThrow() {
    assertDoesNotThrow(() -> {
      Benchmark.main(new String[] {});
    });
  }
}
