/*
 * Decompiled with CFR 0.152.
 */
package collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Stack;

public class RedBlackTree<E extends Comparable<E>>
implements Collection<E> {
    private static final boolean RED = true;
    private static final boolean BLACK = false;
    private Node root;
    private int size = 0;

    private void rotateLeft(Node x) {
        Node y = x.right;
        x.right = y.left;
        if (y.left != null) {
            y.left.parent = x;
        }
        y.parent = x.parent;
        if (x.parent == null) {
            this.root = y;
        } else if (x == x.parent.left) {
            x.parent.left = y;
        } else {
            x.parent.right = y;
        }
        y.left = x;
        x.parent = y;
    }

    private void rotateRight(Node x) {
        Node y = x.left;
        x.left = y.right;
        if (y.right != null) {
            y.right.parent = x;
        }
        y.parent = x.parent;
        if (x.parent == null) {
            this.root = y;
        } else if (x == x.parent.right) {
            x.parent.right = y;
        } else {
            x.parent.left = y;
        }
        y.right = x;
        x.parent = y;
    }

    private void fixAfterInsert(Node z) {
        while (z.parent != null && z.parent.color) {
            Node y;
            if (z.parent == z.parent.parent.left) {
                y = z.parent.parent.right;
                if (y != null && y.color) {
                    z.parent.color = false;
                    y.color = false;
                    z.parent.parent.color = true;
                    z = z.parent.parent;
                    continue;
                }
                if (z == z.parent.right) {
                    z = z.parent;
                    this.rotateLeft(z);
                }
                z.parent.color = false;
                z.parent.parent.color = true;
                this.rotateRight(z.parent.parent);
                continue;
            }
            y = z.parent.parent.left;
            if (y != null && y.color) {
                z.parent.color = false;
                y.color = false;
                z.parent.parent.color = true;
                z = z.parent.parent;
                continue;
            }
            if (z == z.parent.left) {
                z = z.parent;
                this.rotateRight(z);
            }
            z.parent.color = false;
            z.parent.parent.color = true;
            this.rotateLeft(z.parent.parent);
        }
        this.root.color = false;
    }

    private void transplant(Node u, Node v) {
        if (u.parent == null) {
            this.root = v;
        } else if (u == u.parent.left) {
            u.parent.left = v;
        } else {
            u.parent.right = v;
        }
        if (v != null) {
            v.parent = u.parent;
        }
    }

    private Node minimum(Node x) {
        while (x.left != null) {
            x = x.left;
        }
        return x;
    }

    private void fixAfterDelete(Node x, Node parent) {
        while (!(x == this.root || x != null && x.color)) {
            Node w;
            if (parent != null && x == parent.left) {
                w = parent.right;
                if (w != null && w.color) {
                    w.color = false;
                    parent.color = true;
                    this.rotateLeft(parent);
                    w = parent.right;
                }
                if (!(w != null && (w.left != null && w.left.color || w.right != null && w.right.color))) {
                    if (w != null) {
                        w.color = true;
                    }
                    x = parent;
                    parent = x.parent;
                    continue;
                }
                if (w.right == null || !w.right.color) {
                    if (w.left != null) {
                        w.left.color = false;
                    }
                    w.color = true;
                    this.rotateRight(w);
                    w = parent.right;
                }
                if (w != null) {
                    w.color = parent.color;
                }
                parent.color = false;
                if (w != null && w.right != null) {
                    w.right.color = false;
                }
                this.rotateLeft(parent);
                x = this.root;
                break;
            }
            if (parent == null) break;
            w = parent.left;
            if (w != null && w.color) {
                w.color = false;
                parent.color = true;
                this.rotateRight(parent);
                w = parent.left;
            }
            if (!(w != null && (w.right != null && w.right.color || w.left != null && w.left.color))) {
                if (w != null) {
                    w.color = true;
                }
                x = parent;
                parent = x.parent;
                continue;
            }
            if (w.left == null || !w.left.color) {
                if (w.right != null) {
                    w.right.color = false;
                }
                w.color = true;
                this.rotateLeft(w);
                w = parent.left;
            }
            if (w != null) {
                w.color = parent.color;
            }
            parent.color = false;
            if (w != null && w.left != null) {
                w.left.color = false;
            }
            this.rotateRight(parent);
            x = this.root;
            break;
        }
        if (x != null) {
            x.color = false;
        }
    }

    @Override
    public boolean add(E e) {
        Objects.requireNonNull(e);
        if (this.root == null) {
            this.root = new Node(this, e, null);
            this.root.color = false;
            this.size = 1;
            return true;
        }
        Node cur = this.root;
        Node parent = null;
        int cmp = 0;
        while (cur != null) {
            parent = cur;
            cmp = e.compareTo(cur.key);
            if (cmp < 0) {
                cur = cur.left;
                continue;
            }
            if (cmp > 0) {
                cur = cur.right;
                continue;
            }
            return false;
        }
        Node node = new Node(this, e, parent);
        if (cmp < 0) {
            parent.left = node;
        } else {
            parent.right = node;
        }
        this.fixAfterInsert(node);
        ++this.size;
        return true;
    }

    private Node findNode(E e) {
        Node cur = this.root;
        while (cur != null) {
            int cmp = e.compareTo(cur.key);
            if (cmp == 0) {
                return cur;
            }
            if (cmp < 0) {
                cur = cur.left;
                continue;
            }
            cur = cur.right;
        }
        return null;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        try {
            Comparable e = (Comparable)o;
            return this.findNode(e) != null;
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    @Override
    public boolean remove(Object o) {
        Node xParent;
        Node x;
        Comparable e;
        if (o == null) {
            return false;
        }
        try {
            e = (Comparable)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        Node z = this.findNode(e);
        if (z == null) {
            return false;
        }
        Node y = z;
        boolean yOriginalColor = y.color;
        if (z.left == null) {
            x = z.right;
            xParent = z.parent;
            this.transplant(z, z.right);
        } else if (z.right == null) {
            x = z.left;
            xParent = z.parent;
            this.transplant(z, z.left);
        } else {
            y = this.minimum(z.right);
            yOriginalColor = y.color;
            x = y.right;
            if (y.parent == z) {
                if (x != null) {
                    x.parent = y;
                }
                xParent = y;
            } else {
                this.transplant(y, y.right);
                y.right = z.right;
                if (y.right != null) {
                    y.right.parent = y;
                }
                xParent = y.parent;
            }
            this.transplant(z, y);
            y.left = z.left;
            if (y.left != null) {
                y.left.parent = y;
            }
            y.color = z.color;
        }
        if (!yOriginalColor) {
            this.fixAfterDelete(x, xParent);
        }
        --this.size;
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Stack<Node> stack;
            {
                this.stack = this.initStack(RedBlackTree.this.root);
            }

            private Stack<Node> initStack(Node r) {
                Stack<Node> s = new Stack<Node>();
                Node cur = r;
                while (cur != null) {
                    s.push(cur);
                    cur = cur.left;
                }
                return s;
            }

            @Override
            public boolean hasNext() {
                return !this.stack.isEmpty();
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Node n = this.stack.pop();
                Object res = n.key;
                Node cur = n.right;
                while (cur != null) {
                    this.stack.push(cur);
                    cur = cur.left;
                }
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0;
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.size];
        int i = 0;
        for (Comparable e : this) {
            arr[i++] = e;
        }
        return arr;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int i = 0;
        for (Comparable e : this) {
            a[i++] = e;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (Comparable e : c) {
            changed |= this.add((E)e);
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList<Comparable> toRemove = new ArrayList<Comparable>();
        for (Comparable e : this) {
            if (c.contains(e)) continue;
            toRemove.add(e);
        }
        for (Comparable e : toRemove) {
            this.remove(e);
        }
        return !toRemove.isEmpty();
    }

    private static class Node {
        E key;
        Node left;
        Node right;
        Node parent;
        boolean color = true;
        final /* synthetic */ RedBlackTree this$0;

        Node(E key, Node parent) {
            this.this$0 = var1_1;
            this.key = key;
            this.parent = parent;
        }
    }
}

