<?php
namespace App\Entity;

// api/src/entity/Transactions.php
use ApiPlatform\Core\Annotation\ApiResource;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 *
 * @ApiResource
 * @ORM\Entity
 */
class TransactionsEntity
{
    /**
     * @var int The entity Id
     *
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @var \DateTime Transaction date
     *
     * @ORM\Column(type="datetime")
     */
    private $dateTransaction;

    /**
     * @var float price of the transaction
     *
     * @ORM\Column(type="float")
     */
    private $price;

    /**
     * @var string code of the department
     *
     * @ORM\Column(type="text")
     */
    private $codeDepartment;

    /**
     * @var string region of the transaction
     *
     * @ORM\Column(type="text")
     */
    private $region;

    /**
     * @var int square meters of the home
     *
     * @ORM\Column(type="integer")
     */
    private $squareMeters;

    

    /**
     * Get the entity Id
     *
     * @return  int
     */ 
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set the entity Id
     *
     * @param  int  $id  The entity Id
     *
     * @return  self
     */ 
    public function setId(int $id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get transaction date
     *
     * @return  \DateTime
     */ 
    public function getDateTransaction()
    {
        return $this->dateTransaction;
    }

    /**
     * Set transaction date
     *
     * @param  \DateTime  $dateTransaction  Transaction date
     *
     * @return  self
     */ 
    public function setDateTransaction(\DateTime $dateTransaction)
    {
        $this->dateTransaction = $dateTransaction;

        return $this;
    }

    /**
     * Get price of the transaction
     *
     * @return  float
     */ 
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Set price of the transaction
     *
     * @param  float  $price  price of the transaction
     *
     * @return  self
     */ 
    public function setPrice(float $price)
    {
        $this->price = $price;

        return $this;
    }

    /**
     * Get code of the department
     *
     * @return  string
     */ 
    public function getCodeDepartment()
    {
        return $this->codeDepartment;
    }

    /**
     * Set code of the department
     *
     * @param  string  $codeDepartment  code of the department
     *
     * @return  self
     */ 
    public function setCodeDepartment(string $codeDepartment)
    {
        $this->codeDepartment = $codeDepartment;

        return $this;
    }

    /**
     * Get region of the transaction
     *
     * @return  string
     */ 
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * Set region of the transaction
     *
     * @param  string  $region  region of the transaction
     *
     * @return  self
     */ 
    public function setRegion(string $region)
    {
        $this->region = $region;

        return $this;
    }

    /**
     * Get square meters of the home
     *
     * @return  int
     */ 
    public function getSquareMeters()
    {
        return $this->squareMeters;
    }

    /**
     * Set square meters of the home
     *
     * @param  int  $squareMeters  square meters of the home
     *
     * @return  self
     */ 
    public function setSquareMeters(int $squareMeters)
    {
        $this->squareMeters = $squareMeters;

        return $this;
    }
}
