<?php
namespace App\Tests;

use ApiPlatform\Core\Bridge\Symfony\Bundle\Test\ApiTestCase;
use App\Entity\TransactionsEntity;
use Hautelook\AliceBundle\PhpUnit\RefreshDatabaseTrait;

class APITest extends ApiTestCase
{

    public function returnsJSONAndCode200(): void
    {
        $response = static::createClient()->request('GET', '/transactions_entities/square_meter_average_price');

        // Asserts that the response has 200 Status Code
        $this->assertResponseIsSuccessful();
        // Asserts that the returned content type is JSON
        $this->assertResponseHeaderSame('content-type', 'application/json');
    }

    public function testQueryParameter(): void
    {
        $response = static::createClient()->request('GET', '/transactions_entities/sales_by_region', [
            "query" => [
                "year" => 2020
            ]
        ]);

        // Asserts that the response has 200 Status Code
        $this->assertResponseIsSuccessful();
        // Asserts that the returned content type is JSON
        $this->assertResponseHeaderSame('content-type', 'application/json');
    }

    public function testBadRequest(): void
    {
        $response = static::createClient()->request('GET', '/transactions_entities/sales_by_region', [
            "query" => [
                "year" => 2020000
            ]
        ]);
    
        // Asserts that the response has 400 Status Code
        $this->assertResponseStatusCodeSame(400);
        // Asserts that the returned content type is text
        $this->assertResponseHeaderSame('content-type', 'application/text');
    }

    public function testBadRequestBecauseNoParams(): void
    {
        $response = static::createClient()->request('GET', '/transactions_entities/sales_by_region');
    
        // Asserts that the response has 400 Status Code
        $this->assertResponseStatusCodeSame(400);
        // Asserts that the returned content type is text
        $this->assertResponseHeaderSame('content-type', 'application/text');
    }
}

?>