<?php 

namespace App\DataFixtures;

use App\Entity\TransactionsEntity;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Persistence\ObjectManager;
use \DateTime;

class TransactionFixture extends Fixture
{
    public function load(ObjectManager $manager)
    {
        $manager->getConnection()->getConfiguration()->setSQLLogger(null);
        $batch_size = 1000;
        
        $departments = file_get_contents(__DIR__.'/departments.json');
        $departments = json_decode($departments, true);

        $regions = array();
        foreach ($departments as $key => $value)
            $regions[$value["num_dep"]] = $value["region_name"];
    
        $date_format = "d/m/Y";
        for($year = 2015; $year <= 2020; $year++) 
        {
            echo "loading transactions data from the year $year to the db\n";
            $file = fopen(__DIR__."/valeursfoncieres-$year.txt", "r");   
            $cpt = 1;
            $lineInFile = 1;
            $line = fgetcsv($file, 1024, "|");// to remove the header

            while(($line = fgetcsv($file, 1024, "|")) !== FALSE)
            {              
                $typeTransaction = $line[9];
                $typeHome = $line[36];
                
                $date = $line[8];
                $price = $line[10];
                $numDep = $line[18];
                $surface = $line[38];
                
                if($this->checkDatas($typeTransaction, $typeHome, $date, $price, $surface, $numDep))
                {
                    $transaction = new TransactionsEntity();
                    $transaction->setPrice(floatval($price))
                        ->setSquareMeters(intval($surface))
                        ->setDateTransaction(DateTime::createFromFormat($date_format, $date))
                        ->setCodeDepartment($numDep)
                        ->setRegion($regions[$numDep]);

                    $manager->persist($transaction);

                    // Method to avoid to overwhelm the manager capacity
                    $cpt++;
                    if($cpt % $batch_size == 0)
                    {                                 
                        $manager->flush();
                        $manager->clear();
                        echo "$batch_size rows added from file 'valeursfoncieres-$year.txt' to db ($cpt rows added in total, did $lineInFile rows in file)\n";
                    }       
                }

                $lineInFile++;
            }

            echo "Fixture of file 'valeursfoncieres-$year.txt' is over, added a total of $cpt rows.\n";
            $manager->flush();
            $manager->clear();
            fclose($file);
        }
    }

    private function checkDatas($typeTransaction, $typeHome, $date, $price, $surface, $numDep) 
    {
        return strpos(strtolower($typeTransaction), "vente") !== false &&
            (strcmp($typeHome, 'Maison') == 0 || strcmp($typeHome, 'Appartement') == 0) &&
            !is_null($date) && !empty($date) &&
            !is_null($price) && !empty($price) &&
            !is_null($surface) && !empty($surface) &&
            !is_null($numDep) && !empty($numDep);
    }
}
