<?php

namespace App\Controller;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use App\Entity\TransactionsEntity;

class SquareMeterAveragePrice
{
    private $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    public function __invoke(Request $data)
    {
        $query = "SELECT 
                AVG(trans.price / trans.squareMeters) value, 
                to_char(trans.dateTransaction, 'YYYY-MM') month
            FROM 
                App:TransactionsEntity trans
            GROUP BY 
                month";

        $results = $this->em
            ->createQuery($query)
            ->getResult();

        $FormattedResult = array_map(function($data) 
        {
            $data['value'] = floatval($data['value']);
            return $data;
        }, $results);

        return new Response(
            json_encode($FormattedResult),
            Response::HTTP_OK,
            ['content-type' => 'application/json']
        );
    }
}

?>
