<?php

namespace App\Controller;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use App\Entity\TransactionsEntity;

use \DateTime;

class SalesByRegion
{
    private $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    public function __invoke(Request $data)
    {
        $year = $data->query->get('year');

        if(!preg_match('/^\d{4}$/', $year)) {
            return new Response(
                'Bad Request: year is not a number or the format is not YYYY.',
                Response::HTTP_BAD_REQUEST,
                ['content-type' => 'application/text']
            );
        }

        $query = "SELECT
                    trans.region,
                    COUNT(trans) value
                FROM App:TransactionsEntity trans
                WHERE
                    to_char(trans.dateTransaction, 'YYYY') = '$year'
                GROUP BY trans.region";

        $results = $this->em
            ->createQuery($query)
            ->getResult();

        $formattedResult = array_map(function($data) 
        {
            $data['value'] = intval($data['value']);
            return $data;
        }, $results);

        return new Response(
            json_encode($formattedResult),
            Response::HTTP_OK,
            ['content-type' => 'application/json']
        );
    }
}

?>
