<?php

namespace App\Controller;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

use App\Entity\TransactionsEntity;

use \DateTime;

class SalesInTime
{
    private $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    public function __invoke(Request $data)
    {
        $granularity = $data->query->get('granularity');
        $dateStart = $data->query->get('date_start');
        $dateEnd = $data->query->get('date_end');

        $dateRegex = '/^\d{4}-\d{2}-\d{2}$/';
        $granularityRegex = '/^(day|month|year)$/';
        if(!preg_match($dateRegex, $dateStart)) 
        {
            return new Response(
                'Bad Request : wrong date_start format, expected YYYY-mm-dd',
                Response::HTTP_BAD_REQUEST,
                ['content-type' => 'application/text']
            );
        }
        if(!preg_match($dateRegex, $dateEnd)) 
        {
            return new Response(
                'Bad Request : wrong date_end format, expected YYYY-mm-dd',
                Response::HTTP_BAD_REQUEST,
                ['content-type' => 'application/text']
            );
        }

        $start = DateTime::createFromFormat("Y-m-d", $dateStart);
        $end = DateTime::createFromFormat("Y-m-d", $dateEnd);

        if($end < $start) 
        {
            return new Response(
                'Bad Request : date_end before date_start',
                Response::HTTP_BAD_REQUEST,
                ['content-type' => 'application/text']
            );
        }

        if(!preg_match($granularityRegex, $granularity)) 
        {
            return new Response(
                'Bad Request : wrong granularity (expected : year, month, day. Got : '.$granularity.')',
                Response::HTTP_BAD_REQUEST,
                ['content-type' => 'application/text']
            );
        }

        /*switch($granularity)
        {
            case "year":
                $granularity = "YYYY";
            break;
            case "month":
                $granularity = "YYYY-MM";
            break;
            case "day":
                $granularity = "YYYY-MM-DD";
            break;
        }*/
        

        //to_char(trans.dateTransaction, '$granularity') 
        //DATE_TRUNC('$granularity', trans.dateTransaction)
        $query = "SELECT
                   DATE_TRUNC('$granularity', trans.dateTransaction) sales_date,
                    COUNT(trans.price) sales
                  FROM App:TransactionsEntity trans
                  WHERE
                    trans.dateTransaction BETWEEN '$dateStart' AND '$dateEnd'
                  GROUP BY sales_date
                  ORDER BY sales_date";       

        $result = $this->em
            ->createQuery($query)
            ->getResult();

        return new Response(
            json_encode($result),
            Response::HTTP_OK,
            ['content-type' => 'application/json']
        );
    }
}

?>
