<?php
  
  require_once "ArrayPieceSquadro.php";
  require_once "PlateauSquadro.php";
  require_once "ActionSquadro.php";
  require_once "PieceSquadro.php";
  require_once "SquadroUIGenerator.php";
  
  class PieceSquadroUI {

    /**
     * Génère un bouton HTML pour une pièce (blanche ou noire)
     * @param string $couleur Couleur de la pièce ('blanche' ou 'noire')
     * @param int $x Coordonnée X de la pièce
     * @param int $y Coordonnée Y de la pièce
     * @param bool $actif Indique si la pièce est jouable (true) ou non (false)
     * @return string Code HTML du bouton
     */
    
    
     public static function genererBoutonPiece(string $couleur, int $x, int $y, bool $actif): string {
        $class = ($couleur === 'noir') ? 'piece-noire' : 'piece-blanche';
        $disabled = $actif ? "" : "disabled";
        
        return "<button class='$class' name='piece' value='$x-$y' $disabled>$x,$y</button>";
    }

    public static function genererCaseVide(int $x, int $y): string {
        return "<button class='case-vide' disabled></button>";
    }

    public static function genererCaseNeutre(): string {
        return "<button class='case-neutre' disabled>●</button>";
    }
}
?>