<?php
require_once "pieceSquadroUI.php";
require_once "ArrayPieceSquadro.php";
require_once "PlateauSquadro.php";
require_once "ActionSquadro.php";
require_once "PieceSquadro.php";


class SquadroUIGenerator {

    public static function genererPlateau(array $plateau, int $joueurActif): string {
        $html = "<form method='post' action='game.php'>";
        $html .= "<div class='board'>";

        for ($y = 0; $y < 7; $y++) {
            for ($x = 0; $x < 7; $x++) {
                if (isset($plateau[$x][$y])) {
                    $piece = $plateau[$x][$y];
                    $actif = ($piece['joueur'] === $joueurActif);
                    $html .= PieceSquadroUI::genererBoutonPiece($piece['couleur'], $x, $y, $actif);
                } else {
                    $html .= PieceSquadroUI::genererCaseVide($x, $y);
                }
            }
        }

        $html .= "</div><br>";
        $html .= "<button type='submit'>Jouer</button>";
        $html .= "</form>";

        return $html;
    }


    public static function genererPageJeu(array $plateau, int $joueurActif): string {
        return '
        <!DOCTYPE html>
        <html lang="fr">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Squadro</title>
            <link rel="stylesheet" href="plateau.css">
        </head>
        <body>
            <h1>Squadro</h1>
            ' . self::genererPlateau($plateau, $joueurActif) . '
        </body>
        </html>';
    }
    
    


    public static function genererPageConfirmation(int $x, int $y): string {
        return "
            <h1>Confirmation du déplacement</h1>
            <p>Vous avez sélectionné la pièce en ($x, $y). Voulez-vous confirmer votre déplacement ?</p>
            <form method='post' action='index.php'>
                <input type='hidden' name='confirmer' value='$x-$y'>
                <button type='submit'>Confirmer</button>
                <a href='index.php'>Annuler</a>
            </form>
        ";
    }

    public static function genererPageVictoire(string $gagnant): string {
        return "<h1>Fin de partie</h1><p>Le joueur $gagnant a gagné ! 🎉</p><a href='index.php'>Rejouer</a>";
    }

    

}
?>

