<?php
require_once "pieceSquadroUI.php";
require_once "PlateauSquadro.php";
require_once "ActionSquadro.php";
require_once "PieceSquadro.php";
require_once "SquadroUIGenerator.php";
/**
 * Classe permettant de manipuler un ensemble de pièces du jeu Squadro sous forme de tableau.
 */
class ArrayPieceSquadro {
    /** @var array Liste des pièces */
    private array $pieces;

    /**
     * Constructeur initialisant un tableau vide de pièces.
     */
    public function __construct() {
        $this->pieces = [];
    }

    /**
     * Ajoute une pièce à la collection.
     * 
     * @param PieceSquadro $piece La pièce à ajouter
     */
    public function add(PieceSquadro $piece): void {
        $this->pieces[] = $piece;
    }

    /**
     * Supprime une pièce de la collection par son index.
     * 
     * @param int $index Index de la pièce à supprimer
     */
    public function remove(int $index): void {
        if (isset($this->pieces[$index])) {
            array_splice($this->pieces, $index, 1);
        }
    }

    /**
     * Retourne la représentation textuelle du tableau de pièces.
     * 
     * @return string
     */
    public function __toString(): string {
        return implode(", ", array_map(fn($piece) => (string)$piece, $this->pieces));
    }

    /**
     * Convertit la liste de pièces en JSON.
     * 
     * @return string
     */
    public function toJson(): string {
        return json_encode(array_map(fn($piece) => json_decode($piece->toJson(), true), $this->pieces));
    }

    /**
     * Crée une instance de ArrayPieceSquadro à partir d'une chaîne JSON.
     * 
     * @param string $json Représentation JSON de la liste de pièces
     * @return ArrayPieceSquadro
     */
    public static function fromJson(string $json): ArrayPieceSquadro {
        $data = json_decode($json, true);
        $array = new ArrayPieceSquadro();
        foreach ($data as $pieceData) {
            $array->add(PieceSquadro::fromJson(json_encode($pieceData)));
        }
        return $array;
    }
}

