<?php
require_once "../src/PieceSquadro.php";
require_once "../src/ArrayPieceSquadro.php";
require_once "../src/PlateauSquadro.php";
require_once "../src/ActionSquadro.php";
session_start();

// Initialisation du plateau et du joueur actif si ce n'est pas déjà fait
if (!isset($_SESSION['plateau'])) {
    $plateauSquadro = new PlateauSquadro(); 
    $_SESSION['plateau'] = [];  // Initialiser un plateau vide ou récupérer l'état précédent
}
if (!isset($_SESSION['joueurActif'])) {
    $_SESSION['joueurActif'] = 1;  // Joueur 1 commence par défaut
}


// Vérifier si une action a été envoyée via le formulaire
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['piece'])) {
    list($x, $y) = explode('-', $_POST['piece']);  // Récupérer les coordonnées de la pièce choisie

    // Vérifier que la pièce appartient bien au joueur actif
    if (isset($_SESSION['plateau'][$x][$y]) && $_SESSION['plateau'][$x][$y]['joueur'] == $_SESSION['joueurActif']) {
        // Déplacer la pièce (ici, on la retire pour simplifier)
        $_SESSION['plateau'][$x][$y] = null;

        // Changer de joueur après un mouvement
        $_SESSION['joueurActif'] = ($_SESSION['joueurActif'] == 1) ? 2 : 1;

        // Vérifier si la partie est terminée (exemple basique : on arrête si un joueur a gagné)
        if (verifierVictoire()) {
            $_SESSION['victoire'] = true;
            $_SESSION['gagnant'] = ($_SESSION['joueurActif'] == 1) ? 2 : 1;
            header("Location: victory.php");  // Rediriger vers une page de victoire
            exit();
        }

        // Rediriger pour mettre à jour le plateau
        header("Location: index2.php");
        exit();
    } else {
        // Message d'erreur si la pièce sélectionnée ne correspond pas au joueur actif
        echo "<p style='color: red;'>Erreur : Vous ne pouvez déplacer que vos propres pièces.</p>";
    }
}

// Fonction qui vérifie si un joueur a gagné
function verifierVictoire() {
    // Exemple basique : vérifier si un joueur a atteint une condition gagnante (par exemple, toutes les cases occupées par des pièces d'un joueur)
    // Cette logique devra être adaptée aux règles exactes de ton jeu Squadro.

    $joueurActif = $_SESSION['joueurActif'];
    
    // Parcourir le plateau pour vérifier si toutes les cases sont occupées par le joueur actif
    foreach ($_SESSION['plateau'] as $row) {
        foreach ($row as $piece) {
            if (isset($piece) && $piece['joueur'] !== $joueurActif) {
                return false;  // Si une pièce appartient à l'autre joueur, la partie n'est pas terminée
            }
        }
    }

    return true;  // Si toutes les cases sont occupées par le joueur actif, il a gagné
}

// Afficher un lien pour retourner au jeu
echo "<br><a href='index2.php'>Retour au jeu</a>";
?>

