<?php
declare(strict_types=1);
session_start();

require_once '/home/etudiant/mi223957/public_html/squadro_game/src/SquadroUIGenerator.php';
require_once '/home/etudiant/mi223957/public_html/squadro_game/src/PlateauSquadro.php';

// Initialisation du jeu
if (!isset($_SESSION['plateau'])) {
    $_SESSION['plateau'] = new PlateauSquadro();
    $_SESSION['joueurActif'] = 'noire';
}

$plateau = $_SESSION['plateau'];
$joueurActif = $_SESSION['joueurActif'];

// Vérifie si une pièce a été sélectionnée
if (isset($_POST['piece'])) {
    list($x, $y) = explode('-', $_POST['piece']);
    echo SquadroUIGenerator::genererPageConfirmation((int)$x, (int)$y);
    exit;
}

// Vérifie si un déplacement est confirmé
if (isset($_POST['confirmer'])) {
    list($x, $y) = explode('-', $_POST['confirmer']);
    
    // Déplace la pièce
    $plateau->deplacerPiece((int)$x, (int)$y);

    // Vérifie si la partie est terminée
    if ($plateau->checkVictoire()) {
        echo SquadroUIGenerator::genererPageVictoire($joueurActif);
        session_destroy();
        exit;
    }

    // Change de joueur
    $_SESSION['joueurActif'] = ($joueurActif === 'noire') ? 'blanche' : 'noire';
}

// Affichage du plateau
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Squadro Game</title>
    <link rel="stylesheet" href="../css/plateau.css"> <!-- Ajoute un fichier CSS si nécessaire -->
</head>
<body>
    <h1>Squadro - Tour du joueur <?= htmlspecialchars($joueurActif) ?></h1>
    
    <form method="post" action="index.php">
        <?= SquadroUIGenerator::genererPageJeu($plateau, $joueurActif) ?>
    </form>
</body>
</html>
?>
