<?php
require_once "../src/PieceSquadro.php";
require_once "../src/ArrayPieceSquadro.php";
require_once "../src/PlateauSquadro.php";
require_once "../src/ActionSquadro.php";
session_start();

// Récupérer les coordonnées de la pièce sélectionnée
if (isset($_GET['x']) && isset($_GET['y'])) {
    $x = $_GET['x'];
    $y = $_GET['y'];
    
    // Vérifier que la pièce appartient au joueur actif
    $piece = $_SESSION['plateau'][$x][$y];
    if ($piece['joueur'] != $_SESSION['joueurActif']) {
        header("Location: play.php");  // Si la pièce ne correspond pas au joueur, rediriger
        exit();
    }
} else {
    header("Location: play.php");  // Si pas de coordonnées, rediriger
    exit();
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirmer Déplacement</title>
</head>
<body>
    <h1>Confirmer le déplacement</h1>
    <p>Vous avez sélectionné la pièce de couleur <?= $piece['couleur'] ?>. Voulez-vous vraiment la déplacer ?</p>
    <form action="play.php" method="POST">
        <input type="hidden" name="x" value="<?= $x ?>">
        <input type="hidden" name="y" value="<?= $y ?>">
        <button type="submit">Confirmer</button>
    </form>
    <a href="play.php">Annuler</a>
</body>
</html>
