package org.example;

import org.example.entity.BellmanFordResult;
import org.example.entity.PathResult;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;


import static org.example.GraphManipulation.*;

public class Main {
    public static void main(String[] args) {
        System.setProperty("org.graphstream.ui", "swing");

        Graph graph = getTheFileFromPath("src/main/resources/graphe_lehavre.dgs");
        if(graph != null){
            Node startNode = graph.getNode("33317746");
            Node endNode = graph.getNode("144477138");
            BellmanFordResult result = BellmanFord(graph, startNode);
            PathResult pathResult = getPath(result,endNode);
            markPath(pathResult.path());
            System.out.println("Cout du plus court chemin : " +pathResult.cost());
            System.out.println("chemin trouvé : " + pathResult.path());
            graph.setAttribute("ui.stylesheet", "url(file://src/main/resources/style.css)");
            graph.display(false);

        }
    }



}