package org.example;

import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class Utils {

    /**
     * Sauvegarde un histogramme dans un fichier au format texte.
     * Chaque ligne contient soit un seul élément, soit deux éléments séparés par un espace.
     *
     * @param filename Nom du fichier dans lequel écrire l'histogramme.
     * @param histogram Liste de listes de durées (ou valeurs) à enregistrer.
     */
    public static void saveDat(String filename, List<List<Double>> histogram) {
        try (FileWriter writer = new FileWriter(filename)) {
            for (List<Double> durations : histogram) {
                if (durations.size() == 1) {
                    writer.write(durations.get(0) + "\n");
                } else if (durations.size() >= 2) {
                    writer.write(durations.get(0) + " " + durations.get(1) + "\n");

                }
            }
            System.out.println("Histogramme enregistré dans " + filename);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


    /**
     * Sélectionne un nœud aléatoire dans un graphe donné.
     *
     * @param graph Le graphe dans lequel choisir un nœud.
     * @return Un nœud choisi aléatoirement parmi tous les nœuds du graphe.
     */
    public static Node getRandomNode(Graph graph){
        return graph.getNode(ThreadLocalRandom.current().nextInt(0, graph.getNodeCount()));
    }

}
