set terminal pngcairo size 1000,600 enhanced font 'Arial,12'

set title "Propagation du virus sur 3 scénarios"
set xlabel "Jours"
set ylabel "Fraction de population infectée"
set grid ytics

graphs = "dblp random barabasiAlbert"

do for [i=1:3] {
    graph = word(graphs, i)

    set output sprintf("output/SIS_Scenarios_%s.png", graph)
    set title sprintf("Propagation du virus : %s", graph)

    plot sprintf("%s/scenario_no_action.dat", graph)  with linespoints lc rgb "red" title 'Aucun anti-virus', \
         sprintf("%s/scenario_random_immunization.dat", graph)  with linespoints lc rgb "green" title 'Immunisation aléatoire 50%', \
         sprintf("%s/scenario_selective_immunization.dat", graph)  with linespoints lc rgb "blue" title 'Immunisation sélective 50%'
}