# Histogramme comparatif pour 3 graphes (version avec boucle for)
set terminal pngcairo size 1200,600 enhanced font 'Arial,12'
set output 'output/averageDegreeByImmunity_allGraphs.png'

set title "Comparaison du degré moyen par stratégie d'immunisation"
set ylabel "Degré moyen"
set grid ytics

set style data histograms
set style histogram clustered gap 2
set style fill solid 0.7 border -1
set boxwidth 0.9

unset xtics

# Liste des fichiers
filesRandom = "dblp/scenario_random_immunization_degree_avg.dat random/scenario_random_immunization_degree_avg.dat barabasiAlbert/scenario_random_immunization_degree_avg.dat"
filesSelective = "dblp/scenario_selective_immunization_degree_avg.dat random/scenario_selective_immunization_degree_avg.dat barabasiAlbert/scenario_selective_immunization_degree_avg.dat"

plot \
    newhistogram "DBLP" at 0, \
    word(filesRandom, 1)    u 1 title 'S1 (Random) - Imm'     lc rgb "#FF6666", \
    word(filesRandom, 1)    u 2 title 'S1 (Random) - Non Imm' lc rgb "#99FF99", \
    word(filesSelective, 1) u 1 title 'S2 (Select) - Imm'     lc rgb "#6666FF", \
    word(filesSelective, 1) u 2 title 'S2 (Select) - Non Imm' lc rgb "#66FFFF", \
    \
    newhistogram "Graphe Aléatoire" at 1, \
    word(filesRandom, 2)    u 1 notitle lc rgb "#FF6666", \
    word(filesRandom, 2)    u 2 notitle lc rgb "#99FF99", \
    word(filesSelective, 2) u 1 notitle lc rgb "#6666FF", \
    word(filesSelective, 2) u 2 notitle lc rgb "#66FFFF", \
    \
    newhistogram "Barabasi-Albert" at 2 , \
    word(filesRandom, 3)    u 1 notitle lc rgb "#FF6666", \
    word(filesRandom, 3)    u 2 notitle lc rgb "#99FF99", \
    word(filesSelective, 3) u 1 notitle lc rgb "#6666FF", \
    word(filesSelective, 3) u 2 notitle lc rgb "#66FFFF"