package org.example;

import org.graphstream.algorithm.generator.Generator;
import org.graphstream.algorithm.generator.RandomGenerator;
import org.graphstream.algorithm.generator.BarabasiAlbertGenerator;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.SingleGraph;

import java.util.Random;

public class GraphGenerator {

    /**
     * Génère un graphe aléatoire de type Erdős-Rényi G(n, p)
     * @param n nombre de nœuds
     * @param averageDegree degré moyen souhaité
     * @return Graph
     */
    public static Graph generateRandomGraph(int n, double averageDegree) {
        Graph graph = new SingleGraph("Random", false, false);
        Generator gen = new RandomGenerator(averageDegree);
        gen.addSink(graph);
        gen.begin();
        for(int i=0; i<n; i++)
            gen.nextEvents();
        gen.end();
        return graph;
    }

    /**
     * Génère un graphe Barabási-Albert
     * @param n nombre de nœuds
     * @param averageDegree
     * @return Graph
     */
    public static Graph generateBarabasiAlbertGraph(int n, double averageDegree)  {
        Graph graph = new SingleGraph("Barabàsi-Albert",false,false);
        // Between 1 and linksPerNewNode new links per node added.
        int m = Math.max(1, (int) Math.round(averageDegree / 2.0));
        Generator gen = new BarabasiAlbertGenerator(m);
        gen.addSink(graph);
        gen.begin();
        for(int i=0; i<n; i++) {
            gen.nextEvents();
        }

        gen.end();
        return graph;
    }

}
