package org.example;

import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class Gnuplot {

    /**
     * Sauvegarde un histogramme dans un fichier au format texte.
     * Chaque ligne contient soit un seul élément, soit deux éléments séparés par un espace.
     *
     * @param filename Nom du fichier dans lequel écrire l'histogramme.
     * @param histogram Liste de valeurs à enregistrer.
     */
    public static void saveDatSingle(String filename, List<?> histogram) throws IOException {
        try (FileWriter writer = new FileWriter(filename)) {
            for (Object item : histogram) {
                     writer.write(item + "\n");

            }
        }
    }
    public static void saveDatMultipleList(String filename, List<List<?>> columns) throws IOException {
        try (FileWriter writer = new FileWriter(filename)) {
            if (columns == null || columns.isEmpty()) return;

            // On prend le nombre de lignes = taille de la première colonne
            int nRows = columns.get(0).size();

            for (int i = 0; i < nRows; i++) {
                StringBuilder line = new StringBuilder();
                for (int j = 0; j < columns.size(); j++) {
                    List<?> col = columns.get(j);
                    if (i < col.size()) {
                        line.append(col.get(i));
                    } else {
                        line.append(" "); // si une colonne est plus courte
                    }
                    if (j < columns.size() - 1) line.append(" "); // séparateur
                }
                writer.write(line.toString() + "\n");
            }
        }
    }




}
