package org.example;

import org.graphstream.graph.BreadthFirstIterator;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import java.util.Map;

import static org.example.GraphManipulation.*;
import static org.example.Gnuplot.*;
public class Main {
    public static void main(String[] args) {
     System.setProperty("org.graphstream.ui", "swing");
        String path = "src/main/resources/com-dblp.ungraph.txt";
        Graph graph = getTheFileEdge(path);
        int nodeCount = getNodeCount(graph);
        System.out.println("Nombre de noeuds : " + nodeCount);
        System.out.println("Nombre d'arêtes : " +getEdgeCount(graph));
        double averageDegree = getAverageDegree(graph) ;
        System.out.println("Degré Moyen : "+averageDegree);
        System.out.println("Coefficient de clustering : " + getAverageClusteringCoefficient(graph));
        System.out.println("Coefficient de clustering attendu (graphe aléatoire) : "+getRandomGraphClustering(averageDegree,nodeCount));
        System.out.println("Graphe connexe : "+isConnexe(graph));
        System.out.println("Graphe orienté : "+isOrientedGraph(graph));
        getDegreeDistribution(graph);

        Map<Integer,Double> mapProba = getDistanceProbabilities(getProbaDistanceOfNNode(1000,graph));
        List<Integer> distances = new ArrayList<>(mapProba.keySet());
        List<Double> probabilites = new ArrayList<>(mapProba.values());
        List<List<?>> combined = new ArrayList<>();
        combined.add(distances);
        combined.add(probabilites);
        System.out.println(mapProba);
        try {
            saveDatMultipleList("src/main/gnuplot/averageDistanceOf1000Node.dat",combined);
        }

        catch(IOException e) {
            e.printStackTrace();
        }
       System.out.println("Distance Moyennes pour 1000 noeuds : "+ getAverageDistanceOfNNode(1000,graph));






    }
}