# Histogramme du degre moyen par groupe
set terminal pngcairo size 1000,600 enhanced font 'Arial,12'
set output 'averageDegreeByImmunity_histogram.png'

set title "Comparaison du degre moyen selon la strategie d'immunisation"
set ylabel "Degre moyen"
set grid ytics

set style data histograms
set style histogram clustered gap 2
set style fill solid 0.7 border -1
set boxwidth 0.9

set xtics rotate by -15
set key outside right

plot \
'scenario_random_immunization_degree_avg.dat' using 1:xtic("Random - Immunises") title 'Immunises (Random)' lc rgb "#FF6666", \
'' using 2 title 'Non immunises (Random)' lc rgb "#66FF66", \
'scenario_selective_immunization_degree_avg.dat' using 1:xtic("Selective - Immunises") title 'Immunises (Selective)' lc rgb "#6666FF", \
'' using 2 title 'Non immunises (Selective)' lc rgb "#66FFFF"
