package edu.mermet.tp8.aide;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Random;
import java.util.ResourceBundle;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

import edu.mermet.tp8.Application;
import edu.mermet.tp8.Preferences;

public class FenetreSuggestion extends JDialog {
	
	Application application;
	JTextArea tipArea;
	JPanel boutons;
	JButton btnFermer;
	JButton btnNePlusAfficher;
	boolean visible;
	String suggestionKey;
	
	public FenetreSuggestion(Application a){
		super(a, true);
		application = a;
		visible = true;
		init();
		setTitle("Configuration des menus");
		pack();
		setLocationRelativeTo(null);
		setVisible(visible);
	}
	
	private void init() {
		tipArea = new JTextArea(pickATip());
		tipArea.setEditable(false);
		add(tipArea, BorderLayout.CENTER);
		boutons = new JPanel();
		btnFermer = new JButton(new ActionFermer());
		boutons.add(btnFermer);
		btnNePlusAfficher = new JButton(new ActionNePlusAfficher());
		boutons.add(btnNePlusAfficher);
		add(boutons, BorderLayout.SOUTH);
	}

	private String pickATip() {
		ResourceBundle bundleSug = ResourceBundle.getBundle("Suggestions.suggestions");
		bundleSug.getKeys().asIterator();
		Iterator<String> itRes = bundleSug.getKeys().asIterator();
		Map<String, String> suggestionsPossibles = new HashMap<>();
		while(itRes.hasNext()) {
			String key = itRes.next();
			suggestionsPossibles.put(key,bundleSug.getString(key));
		}
		// Suppression des suggestions indésirables
		String[] indesirables = Preferences.getInstance().getSuggestionIndesirables();
		Iterator<Entry<String,String>> itSugPos = 
				suggestionsPossibles.entrySet().iterator();
		while(itSugPos.hasNext()) {
			String key = itSugPos.next().getKey();
			for(String indesirable : indesirables) {
				if(indesirable.equals(key)) {
					itSugPos.remove();
				}
			}
		}
		//-----------------------------------------
		if(suggestionsPossibles.isEmpty()) {
			visible = false;
			return "Plus d'astuces pour vous :(";
		}
		Random rd = new Random();
		int r = rd.nextInt(suggestionsPossibles.size());
		Iterator<Entry<String, String>>  it = suggestionsPossibles.entrySet().iterator();
		for(int i = 0; i < r; i++) {
			it.next();
		}
		Entry<String, String> chosenSuggesiton = it.next();
		suggestionKey = chosenSuggesiton.getKey();
		return chosenSuggesiton.getValue();
	}
	
	public class ActionFermer extends AbstractAction {
        public ActionFermer() {
            super("Fermer");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            dispose();
        }
    }
	
	public class ActionNePlusAfficher extends AbstractAction {
        public ActionNePlusAfficher() {
            super("Ne plus afficher");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
        	Preferences.getInstance().addSuggestionIndesirable(suggestionKey);
        	Preferences.getInstance().persist();
            dispose();
        }
    }
}
