package edu.mermet.tp8.aide;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Scanner;

import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;

import edu.mermet.tp8.Application;

public class FenetreHowTo extends JDialog{
	
	JSplitPane contenu;
	JEditorPane textes;
	JList titres;
	
	public FenetreHowTo(Application parent) {
		super(parent, false);
		init();
		setTitle("Comment faire ?");
		pack();
		setLocationRelativeTo(null);
		setVisible(true);
	}
	
	private void init() {
		loadTitres();
		titres.addListSelectionListener(e->{loadTexte((String) titres.getSelectedValue());});
		titres.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		textes = new JEditorPane();
		textes.setEditable(false);
		textes.setContentType("text/html");
		loadTexte("Default");
		contenu = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		contenu.setLeftComponent(titres);
		contenu.setRightComponent(textes);
		setContentPane(contenu);
	}

	private void loadTexte(String titre) {
		ResourceBundle b = ResourceBundle.getBundle("HowTo.textes");
		textes.setText(b.getString(titre.replace(" ", "_")));
	}

	private void loadTitres() {
		Collection<String> data = new ArrayList<>();
		ResourceBundle b = ResourceBundle.getBundle("HowTo.titres");
		Iterator<String> itRes = b.getKeys().asIterator();
		while(itRes.hasNext())
			data.add(b.getString(itRes.next()));
		titres = new JList(data.toArray());
	}
}
