package edu.mermet.tp8.aide;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;
import java.util.Set;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;

import edu.mermet.tp8.Application;
import edu.mermet.tp8.Preferences;

public class ConfigurationMenus extends JDialog {
	
	Application application;
	
	//tableau radio buttons
	JPanel tableauRadio;
	// Configuration de menus
	Map<String, ButtonGroup> choixMenu; 
	
	//Barre de boutons
	JPanel boutons;
	JButton boutonValider;
	JButton boutonAnnuler;
	
	public ConfigurationMenus(Application application) {
		super(application, true);
		this.application = application;
		init();
		setTitle("Configuration des menus");
		pack();
		setLocationRelativeTo(null);
		setVisible(true);
	}
	
	private void init() {
		try {
			Preferences pref = Preferences.getInstance();
	    	Set<String> MenuModeNames = pref.getMenuModeSet();
	    	choixMenu = new HashMap<>();
			tableauRadio = new JPanel(new GridLayout(MenuModeNames.size(), 4));
			for(String menuModeName : MenuModeNames) {
				JLabel menuLabel = new JLabel(menuModeName.substring(0, menuModeName.length() - "/MenuMode".length()));
				tableauRadio.add(menuLabel);
				ButtonGroup menuRadio = new ButtonGroup();
				JRadioButton autoButton = new JRadioButton("Auto");
				autoButton.setActionCommand(Application.MENU_MODE_AUTO);
				autoButton.setToolTipText("Le programme choisira d'afficher le menu en fonction du niveau de compétance de l'utilisateur");
				menuRadio.add(autoButton);
				tableauRadio.add(autoButton);
				JRadioButton afficheButton = new JRadioButton("Affiché");
				afficheButton.setActionCommand(Application.MENU_MODE_AFFICHE);
				afficheButton.setToolTipText("Toujours affiché");
				menuRadio.add(afficheButton);
				tableauRadio.add(afficheButton);
				JRadioButton cacheButton = new JRadioButton("Caché");
				cacheButton.setActionCommand(Application.MENU_MODE_CACHE);
				cacheButton.setToolTipText("Toujours caché");
				menuRadio.add(cacheButton);
				tableauRadio.add(cacheButton);
				switch(pref.getProperty(menuModeName)) {
				case Application.MENU_MODE_AUTO:
					autoButton.setSelected(true);
					break;
				case Application.MENU_MODE_AFFICHE:
					afficheButton.setSelected(true);
					break;
				case Application.MENU_MODE_CACHE:
					cacheButton.setSelected(true);
					break;
				default:
					autoButton.setSelected(true);
				}
				choixMenu.put(menuModeName, menuRadio);
			}			
			add(tableauRadio, BorderLayout.CENTER);
			boutons = new JPanel();
			boutonValider = new JButton(new ActionValider());
			boutons.add(boutonValider);
			boutonAnnuler = new JButton(new ActionAnnuler());
			boutons.add(boutonAnnuler);
			add(boutons, BorderLayout.SOUTH);
		} catch(Exception e) {
    		e.printStackTrace();
    		System.err.println("Impossible d'utiliser les données de l'utilisateur");
    		dispose();
    	}
	}
	
    private class ActionValider extends AbstractAction {
        public ActionValider() {
            super("Valider");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
        	try {
        		Preferences pref = Preferences.getInstance();
	        	Set<Entry<String, ButtonGroup>> choix = choixMenu.entrySet();
	        	for(Entry<String, ButtonGroup> entry : choix) {
	        		pref.setProperty(entry.getKey() , entry.getValue().getSelection().getActionCommand());
        		}
	        	pref.persist();
	            application.refreshMenuMode();
	            dispose();
        	} catch(Exception e) {
        		e.printStackTrace();
        		System.err.println("Impossible d'utiliser les données de l'utilisateur");
        	}
        }
    }
    
    private class ActionAnnuler extends AbstractAction {
        public ActionAnnuler() {
            super("Annuler");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            dispose();
        }
    }
}
