package edu.mermet.tp8;


import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

import edu.mermet.tp8.Application;

public class Preferences {
	
	static Preferences instance;
	Properties prefUtilisateur;
	String path;

	
	private Preferences() {	
		prefUtilisateur = new Properties();
		path =  System.getProperty("user.home") + "/.ihm/" + System.getProperty("user.name") + ".xml";
		try {
			File donneesUtilisateur = new File(path);
			if(!donneesUtilisateur.exists()) {
				File ihmDirectory = new File(System.getProperty("user.home") + "/.ihm");
				if(!Files.isDirectory(ihmDirectory.toPath())) {
					Files.createDirectory(ihmDirectory.toPath());
				}
				System.out.println("ah bah non");
				OutputStream os = new FileOutputStream(donneesUtilisateur);
				prefUtilisateur.setProperty("Conversion/MenuMode", Application.MENU_MODE_AUTO);
				prefUtilisateur.setProperty("Saisie de Texte/MenuMode", Application.MENU_MODE_AUTO);
				prefUtilisateur.setProperty("Diaporama/MenuMode", Application.MENU_MODE_AUTO);
				prefUtilisateur.setProperty("Boutons/MenuMode", Application.MENU_MODE_AUTO);
				prefUtilisateur.setProperty("Niveau", String.valueOf(0.));
				prefUtilisateur.storeToXML(os, null, "UTF-8");
			} else {
				prefUtilisateur.loadFromXML(new FileInputStream(new File(path)));
			}
		} catch(Exception e) {
			e.printStackTrace();
			System.out.println("Impossible d'utiliser les données de l'utilisateur");
		}
	}
	
	public static Preferences getInstance() {
		if(instance == null)
			instance = new Preferences();
		return instance;
	}
	
	public String[] getSuggestionIndesirables() {
		String suggInd  = prefUtilisateur.getProperty("SuggestionsIndesirables");
		if(suggInd == null) {
			return new String[0];
		} else {
			String[] res = suggInd.split(",");
			return res;
		}
	}
	
	public void addSuggestionIndesirable(String keySuggestion) {
		String suggInd  = prefUtilisateur.getProperty("SuggestionsIndesirables");
		if("".equals(suggInd) || suggInd == null)
			suggInd = keySuggestion;
		else
			suggInd += "," + keySuggestion;
		prefUtilisateur.setProperty("SuggestionsIndesirables", suggInd);
	}
	
	public void setProperty(String key, String value) {
		prefUtilisateur.setProperty(key, value);
	}
	
	public String getProperty(String key) {
		return prefUtilisateur.getProperty(key);
	}
	
	public Set<String> getMenuModeSet() {
		Set<Object> propertiesNames = prefUtilisateur.keySet();
    	Set<String> MenuModeNames = new HashSet<>();
    	for(Object name : propertiesNames) {
    		if(((String) name).contains("/MenuMode")) {
    			MenuModeNames.add((String) name);
    		}
    	}
    	return MenuModeNames;
	}
	
	public float getNiveau() {
		return Float.parseFloat(prefUtilisateur.getProperty("Niveau"));
	}
	
	public void upNiveau(float xp) {
		float niveauActuel = getNiveau();
		prefUtilisateur.setProperty("Niveau", String.valueOf(niveauActuel + xp));
	}
	
	public void persist() {
		try {
			prefUtilisateur.storeToXML(new FileOutputStream(new File(path)), null);
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Impossible d'utiliser les données de l'utilisateur");
		}
	}
}
