package edu.mermet.tp8;


import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;
import java.util.ResourceBundle;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

import edu.mermet.tp8.aide.ConfigurationMenus;
import edu.mermet.tp8.aide.FenetreHowTo;
import edu.mermet.tp8.aide.FenetreSuggestion;
import edu.mermet.tp8.fenetres.FenetreBoutons;
import edu.mermet.tp8.fenetres.FenetreConversion;
import edu.mermet.tp8.fenetres.FenetreDiaporama;
import edu.mermet.tp8.fenetres.FenetreTexte;
import edu.mermet.tp8.Preferences;

/**
 *
 * @author brunomermet
 */
public class Application extends JFrame {
	
	public final static String MENU_MODE_AUTO = "auto";
	public final static String MENU_MODE_AFFICHE = "affichée";
	public final static String MENU_MODE_CACHE = "cachée";
	
    private JInternalFrame conversion;
    private JInternalFrame texte;
    private JInternalFrame diaporama;
    private JInternalFrame boutons;
    private Action actionAfficherConversion;
    private Action actionAfficherTexte;
    private Action actionAfficherDiaporama;
    private Action actionAfficherBoutons;
    private Action actionHowTo;
    private Action actionConfigurationMenus;
    JMenuItem itemConversion;
    JMenuItem itemTexte;
    JMenuItem itemDiaporama;
    JMenuItem itemBoutons;
    public Application() {
        super("multi-fenêtres");
        this.setContentPane(new JDesktopPane());

        // ****** Barre de menu ******
        JMenuBar barre = new JMenuBar();
        // ------ menu Fichier ------
        JMenu menuFichier = new JMenu("Fichier");
        menuFichier.setMnemonic(KeyEvent.VK_F);
        JMenuItem quitter = new JMenuItem("Quitter");
        quitter.addActionListener (new ActionQuitter());
        menuFichier.add(quitter);
        barre.add(menuFichier);
        this.setJMenuBar(barre);
        // ------ menu Applications ------
        JMenu menuApplication = new JMenu("Applications");
        menuApplication.setMnemonic(KeyEvent.VK_A);
        actionAfficherConversion = new ActionAfficherConversion();
        itemConversion = new JMenuItem(actionAfficherConversion);
        menuApplication.add(itemConversion);
        actionAfficherTexte = new ActionAfficherTexte();
        itemTexte = new JMenuItem(actionAfficherTexte);
        menuApplication.add(itemTexte);
        actionAfficherDiaporama = new ActionAfficherDiaporama();
        itemDiaporama = new JMenuItem(actionAfficherDiaporama);
        menuApplication.add(itemDiaporama);
        actionAfficherBoutons = new ActionAfficherBoutons();
        itemBoutons = new JMenuItem(actionAfficherBoutons);
        menuApplication.add(itemBoutons);
        refreshMenuMode();
        barre.add(menuApplication);
        // ------ menu Aide ------
        JMenu menuAide = new JMenu("Aide");
        menuAide.setMnemonic(KeyEvent.VK_H); // "Help"
        actionHowTo = new ActionHowTo();
        JMenuItem itemHowTo = new JMenuItem(actionHowTo);
        menuAide.add(itemHowTo);
        actionConfigurationMenus = new ActionConfigurationMenus();
        JMenuItem itemConfigurationMenus = new JMenuItem(actionConfigurationMenus);
        menuAide.add(itemConfigurationMenus);
        barre.add(menuAide);
        // ****** Fin barre de menu ******
        
        // ****** Création des fenêtres ******
        // ------ fenêtre conversion ------
        conversion = new FenetreConversion(actionAfficherConversion);
        this.add(conversion);
        // ------ fenêtre texte ------
        texte = new FenetreTexte(actionAfficherTexte);
        this.add(texte);
        // ------ fenêtre diaporama ------
        diaporama = new FenetreDiaporama(actionAfficherDiaporama);
        this.add(diaporama);
        // ------ fenêtre boutons ------
        boutons = new FenetreBoutons(this,actionAfficherBoutons);
        this.add(boutons);
        // ****** Fin création fenêtres ******
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setSize(600,300);
        this.setLocationRelativeTo(null);
        setVisible(true);
        new FenetreSuggestion(this);
    }

    public void refreshMenuMode() {
    	// System.getenv("HOME") ne fonctionne pas sur ma machine
    	Preferences pref = Preferences.getInstance();
    	try {
			itemConversion.setVisible(shouldHide(pref.getProperty("Conversion/MenuMode"), "Conversion Celsius/Farenheit"));
			itemTexte.setVisible(shouldHide(pref.getProperty("Saisie de Texte/MenuMode"), "Saisie de texte"));
			itemDiaporama.setVisible(shouldHide(pref.getProperty("Diaporama/MenuMode"), "Diaporama"));
			itemBoutons.setVisible(shouldHide(pref.getProperty("Boutons/MenuMode"), "Boutons"));
    	} catch(Exception e) {
    		e.printStackTrace();
    		System.err.println("Impossible d'utiliser les données de l'utilisateur");
    	}
    }
    
    private static boolean shouldHide(String menuMode, String nomFonc) {
    	switch(menuMode) {
    	case MENU_MODE_AFFICHE:
    		return true;
		case MENU_MODE_CACHE:
    		return false;
		default: 
    	case MENU_MODE_AUTO:
    		ResourceBundle b = ResourceBundle.getBundle("fonctionnalites");
    		Float niveauRequis = Float.parseFloat(b.getString(nomFonc.replace(' ', '_')));
    		return Preferences.getInstance().getNiveau() >= niveauRequis;	
    	}
    }

    private class ActionQuitter extends ActionFonctionnalite {
        public ActionQuitter() {
            super("Quitter", Application.this);
            putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke(KeyEvent.VK_Q, InputEvent.CTRL_DOWN_MASK));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            xp();
            System.exit(0);
        }
    }
    
	private class ActionAfficherBoutons extends ActionFonctionnalite {
        public ActionAfficherBoutons() {
            super("Boutons", Application.this);
            putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke(KeyEvent.VK_B, InputEvent.CTRL_DOWN_MASK));
            putValue(Action.MNEMONIC_KEY, KeyEvent.VK_B);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            boutons.setVisible(true);
            enableBoutons(false);
            xp();
        }
    }
	
    private class ActionAfficherDiaporama extends ActionFonctionnalite {
        public ActionAfficherDiaporama() {
            super("Diaporama", Application.this);
            putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke(KeyEvent.VK_D, InputEvent.CTRL_DOWN_MASK));
            putValue(Action.MNEMONIC_KEY, KeyEvent.VK_D);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            diaporama.setVisible(true);
            enableDiaporama(false);
            xp();
        }
    }

    private class ActionAfficherTexte extends ActionFonctionnalite {
        public ActionAfficherTexte() {
            super("Saisie de texte", Application.this);
            putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke(KeyEvent.VK_T, InputEvent.CTRL_DOWN_MASK));
            putValue(Action.MNEMONIC_KEY, KeyEvent.VK_T);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            texte.setVisible(true);
            enableTexte(false);
            xp();
        }
    }
    
    public class ActionAfficherConversion extends ActionFonctionnalite {
        public ActionAfficherConversion() {
            super("Conversion Celsius/Farenheit", Application.this);
            putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke(KeyEvent.VK_C, InputEvent.CTRL_DOWN_MASK));
            putValue(Action.MNEMONIC_KEY, KeyEvent.VK_C);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            conversion.setVisible(true);
            enableConversion(false);
            xp();
        }
    }
    
    private class ActionHowTo extends AbstractAction {
        public ActionHowTo() {
            super("Comment faire ?");
            putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_F, InputEvent.CTRL_DOWN_MASK));
            putValue(Action.MNEMONIC_KEY,KeyEvent.VK_F);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            new FenetreHowTo(Application.this);
        }
    }
    
    private class ActionConfigurationMenus extends AbstractAction {
        public ActionConfigurationMenus() {
            super("Configuration des menus");
            putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_G, InputEvent.CTRL_DOWN_MASK));
            putValue(Action.MNEMONIC_KEY,KeyEvent.VK_G);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            new ConfigurationMenus(Application.this);
        }
    }

    public void enableConversion(boolean b) {
        actionAfficherConversion.setEnabled(b);
    }

    public void enableTexte(boolean b) {
        actionAfficherTexte.setEnabled(b);
    }

    public void enableDiaporama(boolean b) {
        actionAfficherDiaporama.setEnabled(b);
    }

    public void enableBoutons(boolean b) {
        actionAfficherBoutons.setEnabled(b);
    }

    public Action getActionAfficherConversion() {
        return actionAfficherConversion;
    }

    public Action getActionAfficherTexte() {
        return actionAfficherTexte;
    }

    public Action getActionAfficherDiaporama() {
        return actionAfficherDiaporama;
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(Application::new);
    }
    
}
