import java.awt.event.KeyEvent;
import javax.swing.*;

public class Fenetre extends JFrame {
    public Fenetre() {
        super("Courbes");

        this.init();
        this.setDefaultCloseOperation(EXIT_ON_CLOSE);
        this.setSize(800, 700);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void init() {
        DonneesPanel donneesPanel = new DonneesPanel();
        CourbePanel courbePanel = new CourbePanel(donneesPanel);

        JMenuBar menuBar = new JMenuBar();
        JMenu menuFichier = new JMenu("Fichier");
        JMenu menuDonnees = new JMenu("Données");

        menuFichier.add(new DummyAction("Quitter", KeyEvent.VK_Q, e -> {
            System.exit(0);
        }));

        menuDonnees.add(new DummyAction("Redessiner", KeyEvent.VK_R, e -> {
            courbePanel.repaint();
        }));

        menuDonnees.add(new DummyAction("Ajouter une colonee", KeyEvent.VK_A, e -> {
            donneesPanel.ajouterColonne();
        }));

        menuDonnees.add(new DummyAction("Supprimer une colonne", KeyEvent.VK_S, e -> {
            donneesPanel.supprimerColonne();
        }));

        menuDonnees.add(new DummyAction("Effacer les données", KeyEvent.VK_E, e -> {
            donneesPanel.effacerDonnees();
        }));

        menuBar.add(menuFichier);
        menuBar.add(menuDonnees);

        JSplitPane splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT, donneesPanel, courbePanel);
        splitPane.setDividerLocation(350);

        this.add(splitPane);
        this.setJMenuBar(menuBar);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(Fenetre::new);
    }
}
