import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class DummyAction extends AbstractAction {
    private ActionListener listener;

    public DummyAction(String name, ActionListener listener) {
        super(name);
        this.listener = listener;
    }

    public DummyAction(String name, KeyStroke stroke, ActionListener listener) {
        super(name);
        putValue(ACCELERATOR_KEY, stroke);
        this.listener = listener;
    }

    public DummyAction(String name, Integer mnemonic, ActionListener listener) {
        super(name);
        putValue(MNEMONIC_KEY, mnemonic);
        this.listener = listener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        listener.actionPerformed(e);
    }
}
