// Définition du prototype Car
function Car(image, make, model, description, price, category, year, mileage, extras) {
	this.image = image;
	this.make = make;
	this.model = model;
	this.description = description;
	this.price = price;
	this.category = category;
	this.year = year;
	this.mileage = mileage;
	this.extras = extras;
}

Car.prototype.generateImage = function(elt) {
	var imgElement = document.createElement('img');
	imgElement.src = this.image;
	imgElement.alt = this.make + " " + this.model;
	imgElement.classList.add('card-img-top');

	elt.appendChild(imgElement);
}

Car.prototype.generateExtras = function(elt) {
	var ulElement = document.createElement('ul');

	this.extras.forEach(function(extra) {
	  var liElement = document.createElement('li');
	  var extraText = extra.name + ' - ' + extra.price;
	  var textNode = document.createTextNode(extraText);
	  liElement.appendChild(textNode);
	  ulElement.appendChild(liElement);
	});
  
	elt.appendChild(ulElement);
}

