import 'package:flutter/material.dart';

void main() => runApp(MyApp());

class MyApp extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Flutter Demo',
      debugShowCheckedModeBanner: false,
      theme: ThemeData(
        primarySwatch: Colors.blue,
      ),
      home: MyHomePage(title: 'Game'),
    );
  }
}

class MyHomePage extends StatefulWidget {
  MyHomePage({Key key, this.title}) : super(key: key);

  final String title;

  @override
  _MyHomePageState createState() => _MyHomePageState();
}

class _MyHomePageState extends State<MyHomePage> {
  TextStyle _textStyleDefault = TextStyle(
    color: Colors.white,
  );

  TextStyle _textStyleSaisie = TextStyle(
    color: Colors.amber[900],
    fontWeight: FontWeight.bold,
  );

  String _motClef = 'issam';
  String _tf = '';
  String _imageLink = 'Assets/images/un.png';

  final _controller = TextEditingController();

  _getChamp() {
    setState(() {
      _tf = _controller.text.toLowerCase();
    });
  }
  // Getting the nu,ber of letters in the String
  numberOfString() {
    String x='';
    int len = _motClef.length;
    x = len.toString();
    return x;
  }

  void initState() {
    super.initState();
    _controller.addListener(_getChamp);
    _controller.value = TextEditingValue(text: '$_tf');
  }

  //Chqnging the image depennding on the letter entered
  checkingTheString (){
    String val = _controller.text.toLowerCase();
    int j = int.parse(numberOfString());
    int lengthText = _controller.text.length;
    for(int i =0; i<=j;i++){
      if(_motClef.contains(val) ){
        _imageLink = 'Assets/images/un.png';
        return _imageLink;
      }else{
        _imageLink = 'Assets/images/deux.png';
        return _imageLink;
      }
    }
  }

  void dispose() {
    _controller.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(widget.title),
      ),
      body: Padding(
        padding: const EdgeInsets.all(20.0),
        child: Center(
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Text(
                'Number of letters: '+numberOfString(),
                style: _textStyleSaisie,
              ),
              TextField(
                controller: _controller,
                decoration: InputDecoration(border: OutlineInputBorder()),
                keyboardType: TextInputType.text,
              ),
              Padding(padding: EdgeInsets.only(bottom: 20)),
              Container(
                width: MediaQuery.of(context).size.width * 0.7,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.spaceAround,
                  children: <Widget>[
                    Padding(padding: EdgeInsets.only(top: 10)),
                    Text(
                      '$_tf',
                      style: _textStyleSaisie,
                    ),
                    Image.asset(
                      checkingTheString(),
                      width: 150,
                    ),
                    Padding(padding: EdgeInsets.only(bottom: 10)),
                  ],
                ),
                decoration: BoxDecoration(
                    color: Colors.blue,
                    borderRadius: BorderRadius.circular(6),
                    boxShadow: [
                      BoxShadow(
                          color: Colors.black,
                          blurRadius: 20.0,
                          spreadRadius: .0,
                          offset: Offset(0, 15))
                    ]),
              )
            ],
          ),
        ),
      ),
    );
  }
}