<?php

namespace App\tests\Api;

use ApiPlatform\Symfony\Bundle\Test\ApiTestCase;
use App\Factory\DepartementFactory;

class DepartementTest extends ApiTestCase
{
    public function testGetDepartementCollection(): void
    {
        // Remplace '/api/taxes' par l'URL réelle de ta ressource API
        $response = static::createClient()->request('GET', '/departements');

        $this->assertResponseIsSuccessful();

        // Vérifie que c'est du JSON-LD (standard API Platform)
        $this->assertJsonContains([
            '@type' => 'Collection',
        ]);
    }

    public function testGetDepartement(): void
    {
        $departement = DepartementFactory::createOne();

        $response = static::createClient()->request('GET', '/departements/' . $departement->getId());

        $this->assertResponseIsSuccessful();

        $this->assertJsonContains([
            'id' => $departement->getId(),
        ]);

    }
}
