<?php

namespace App\tests\Api;

use ApiPlatform\Symfony\Bundle\Test\ApiTestCase;
use App\Factory\CommuneFactory;

class CommuneTest extends ApiTestCase
{
    public function testGetCommunesCollection(): void
    {
        $response = static::createClient()->request('GET', '/communes');

        $this->assertResponseIsSuccessful();

        // Vérifie que c'est du JSON-LD (standard API Platform)
        $this->assertJsonContains([
            '@type' => 'Collection',
        ]);
    }

    public function testGetCommune(): void
    {
        $commune = CommuneFactory::createOne();

        $response = static::createClient()->request('GET', '/communes/' . $commune->getId());

        $this->assertResponseIsSuccessful();

        $this->assertJsonContains([
            '@id' => '/communes/' . $commune->getId(),
        ]);
    }
}
