<?php

namespace App\Factory;

use App\Entity\Departement;
use Zenstruck\Foundry\Persistence\PersistentObjectFactory;

/**
 * @extends PersistentObjectFactory<Departement>
 */
final class DepartementFactory extends PersistentObjectFactory
{
    #[\Override]
    public static function class(): string
    {
        return Departement::class;
    }

    /**
     * @see https://symfony.com/bundles/ZenstruckFoundryBundle/current/index.html#model-factories
     *
     */
    #[\Override]
    protected function defaults(): array|callable
    {
        return [
            'code' => self::faker()->randomNumber(),
            'nom' => self::faker()->text(255),
            'region' => RegionFactory::new(),
        ];
    }

    /**
     * @see https://symfony.com/bundles/ZenstruckFoundryBundle/current/index.html#initialization
     */
    #[\Override]
    protected function initialize(): static
    {
        return $this
            // ->afterInstantiate(function(Departement $departement): void {})
        ;
    }
}
