<?php

namespace App\ApiResource;

use ApiPlatform\Metadata\ApiProperty;
use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\GetCollection;
use ApiPlatform\OpenApi\Model\Operation;
use ApiPlatform\OpenApi\Model\Parameter;
use App\State\RegionVolumeStatsProvider;

#[ApiResource(
    operations: [
        new GetCollection(
            uriTemplate: '/stats/total-volume-by-region',
            openapi: new Operation(
                summary: 'Récupère la répartition des volumes par région pour une année et un type de taxe.',
                parameters: [
                    new Parameter(
                        name: 'year',
                        in: 'query',
                        description: 'Année concernée',
                        required: true,
                        schema: ['type' => 'integer']
                    ),
                    new Parameter(
                        name: 'typeCode',
                        in: 'query',
                        description: 'Code du type de taxe (ex: TFPNB, TH...)',
                        required: true,
                        schema: ['type' => 'string']
                    ),
                ]
            ),
            provider: RegionVolumeStatsProvider::class
        )
    ],
    paginationEnabled: false
)]
class RegionVolumeStats
{
    #[ApiProperty(identifier: true)]
    public string $id;

    public string $region;

    public float $totalVolume;

    public function __construct(string $region, float $totalVolume)
    {
        $this->region = $region;
        $this->totalVolume = $totalVolume;
        $this->id = sprintf('%s-%s', $region, uniqid());
    }
}

