import { Chart as ChartJS, LinearScale, PointElement, Tooltip as ChartJSTooltip, Legend } from 'chart.js';
import type { ChartData, ChartOptions } from 'chart.js';
import { Scatter } from 'react-chartjs-2';

type Point = { commune: string; taux: number; volume: number };

export default function ScatterPlot({ data }: { data: Point[] }) {

  ChartJS.register(LinearScale, PointElement, ChartJSTooltip, Legend);

  const chartData: ChartData<'scatter'> = {
    datasets: [
      {
        label: 'Communes',
        data: data.map((p) => ({ x: p.taux, y: p.volume, commune: p.commune } as any)),
        backgroundColor: 'var(--color-Communes)',
        pointRadius: 4,
      },
    ],
  };

  const options: ChartOptions<'scatter'> = {
    responsive: true,
    maintainAspectRatio: false,
    animation: false,
    scales: {
      x: {
        type: 'linear',
        title: { display: true, text: 'Taux (%)' },
      },
      y: {
        title: { display: true, text: 'Volume (€)' },
      },
    },
    plugins: {
      tooltip: {
        callbacks: {
          title: () => '',
          label: (ctx) => {
            const r: any = ctx.raw;
            const commune = r?.commune ?? '';
            return `${commune} — Taux: ${r.x}%, Volume: €${r.y}`;
          },
        },
      },
      legend: { display: false },
    },
  };

  return (
      <div style={{ width: '100%', height: 360 }}>
        <Scatter data={chartData} options={options} />
      </div>
  );
}
