import {
  LineChart,
  Line,
  XAxis,
  YAxis,
  Tooltip,
  Legend,
  ResponsiveContainer,
  CartesianGrid
} from 'recharts';

type SeriesDatum = { year: number; [key: string]: number | string };

export default function TimeSeriesChart({
  data,
  regions,
  colors = [] as string[]
}: {
  data: SeriesDatum[]; // each item: { year, RegionA: value, RegionB: value }
  regions: string[]; // region keys to plot
  colors?: string[];
}) {
  const palette = colors.length ? colors : ['#0B5FFF', '#00A78E', '#FFB020', '#6B21A8'];

  return (
    <ResponsiveContainer width="100%" height={320}>
      <LineChart data={data} margin={{ top: 12, right: 24, left: 0, bottom: 12 }}>
        <CartesianGrid strokeDasharray="3 3" />
        <XAxis dataKey="year" />
        <YAxis />
        <Tooltip />
        <Legend />
        {regions.map((r, i) => (
          <Line
            key={r}
            type="monotone"
            dataKey={r}
            stroke={palette[i % palette.length]}
            strokeWidth={2}
            dot={{ r: 2 }}
            activeDot={{ r: 4 }}
            connectNulls
          />
        ))}
      </LineChart>
    </ResponsiveContainer>
  );
}
