import {
  ScatterChart,
  Scatter,
  XAxis,
  YAxis,
  Tooltip,
  CartesianGrid,
  ResponsiveContainer
} from 'recharts';

type Point = { commune: string; taux: number; volume: number };

export default function ScatterPlot({ data }: { data: Point[] }) {
  return (
    <ResponsiveContainer width="100%" height={300}>
      <ScatterChart margin={{ top: 12, right: 24, left: 0, bottom: 12 }}>
        <CartesianGrid />
        <XAxis type="number" dataKey="taux" name="Taux" unit="" />
        <YAxis type="number" dataKey="volume" name="Volume" unit="€" />
        <Tooltip cursor={{ strokeDasharray: '3 3' }} />
        <Scatter name="Communes" data={data} fill="#0B5FFF" />
      </ScatterChart>
    </ResponsiveContainer>
  );
}
