import { PieChart, Pie, Legend } from "recharts";
import { Card, CardContent } from "@/components/ui/card";
import {
	ChartContainer,
	ChartTooltip,
	ChartTooltipContent,
	type ChartConfig,
} from "@/components/ui/chart";

export default function PieChartPanel({
	data,
}: {
	data: { name: string; value: number }[];
}) {
	const BASE_COLORS = [
		"#0B5FFF",
		"#00A78E",
		"#FFB020",
		"#6B21A8",
		"#475569",
		"#EF4444",
		"#10B981",
		"#6366F1",
		"#F59E0B",
		"#E11D48",
		"#06B6D4",
		"#8B5CF6",
	];

	const count = data ? data.length : 0;
	const palette =
		count > 0 && count > BASE_COLORS.length
			? Array.from(
					{ length: count },
					(_, i) => `hsl(${Math.round((i * 360) / count)},65%,50%)`,
				)
			: BASE_COLORS;

	const chartData = data.map((d, i) => {
		return {
			name: d.name,
			taxs: d.value,
			fill: palette[i % palette.length],
		};
	});

	const chartConfig = chartData.reduce((acc, d, i) => {
		acc[d.name] = { label: d.name, color: palette[i % palette.length] };
		return acc;
	}, {taxs: { label: "Impôts"}} as ChartConfig) satisfies ChartConfig;
	console.log(chartConfig);
	return (
		<Card className="flex flex-col">
			<CardContent className="flex-1 pb-0">
				<ChartContainer
					config={chartConfig}
					className="mx-auto max-h-[300px]"
				>
					<PieChart margin={{ top: 0, right: 100, bottom: 0, left: 0 }}>
						<ChartTooltip content={<ChartTooltipContent />} />
						<Legend verticalAlign="middle" align="right" layout="vertical" wrapperStyle={{ right: 0 }} />

						<Pie
							data={chartData}
							dataKey="taxs"
							nameKey="name"
							innerRadius={60}
							outerRadius={100}
						/>
					</PieChart>
				</ChartContainer>
			</CardContent>
		</Card>
	);
}
