import {
  ScatterChart,
  Scatter,
  XAxis,
  YAxis,
  Tooltip,
  CartesianGrid,
} from 'recharts';
import {
  ChartContainer,
  ChartTooltip,
  ChartTooltipContent,
} from '@/components/ui/chart';

type Point = { commune: string; taux: number; volume: number };

export default function ScatterPlot({ data }: { data: Point[] }) {
  const config = {
    Communes: { label: 'Communes', color: '#0B5FFF' },
  } as const;

  return (
    <ChartContainer config={config}>
      <ScatterChart margin={{ top: 12, right: 24, left: 0, bottom: 12 }}>
        <CartesianGrid />
        <XAxis type="number" dataKey="taux" name="Taux" unit="" label={{ value: 'Taux (%)', position: 'insideBottom', offset: -5 }} />
        <YAxis type="number" dataKey="volume" name="Volume" unit="€" label={{ value: 'Volume (€)', angle: -90, position: 'insideLeft' }} />
        <ChartTooltip content={<ChartTooltipContent />}  />
        <Scatter name="Communes" data={data} fill="var(--color-Communes)" />
      </ScatterChart>
    </ChartContainer>
  );
}
