<?php

namespace App\tests\Api;

use ApiPlatform\Symfony\Bundle\Test\ApiTestCase;
use App\Factory\TaxeFactory;

class TaxeTest extends ApiTestCase
{
    public function testGetTaxesCollection(): void
    {
        // Remplace '/api/taxes' par l'URL réelle de ta ressource API
        $response = static::createClient()->request('GET', '/taxes');

        $this->assertResponseIsSuccessful();

        // Vérifie que c'est du JSON-LD (standard API Platform)
        $this->assertJsonContains([
            '@type' => 'Collection',
        ]);
    }

    public function testGetTaxe(): void
    {
        $taxe = TaxeFactory::createOne();

        $response = static::createClient()->request('GET', '/taxes/' . $taxe->getId());

        $this->assertResponseIsSuccessful();

        $this->assertJsonContains([
            'id' => $taxe->getId(),
        ]);

    }
}
