<?php

namespace App\tests\Api;

use ApiPlatform\Symfony\Bundle\Test\ApiTestCase;
use App\Factory\RegionFactory;

class RegionTest extends ApiTestCase
{
    public function testGetRegionCollection(): void
    {
        // Remplace '/api/taxes' par l'URL réelle de ta ressource API
        $response = static::createClient()->request('GET', '/regions');

        $this->assertResponseIsSuccessful();

        // Vérifie que c'est du JSON-LD (standard API Platform)
        $this->assertJsonContains([
            '@type' => 'Collection',
        ]);
    }

    public function testGetRegion(): void
    {
        $region = RegionFactory::createOne();

        $response = static::createClient()->request('GET', '/regions/' . $region->getId());

        $this->assertResponseIsSuccessful();

        $this->assertJsonContains([
            'id' => $region->getId(),
        ]);

    }
}
{

}
