<?php

namespace App\Factory;

use App\Entity\TypeTaxe;
use Zenstruck\Foundry\Persistence\PersistentObjectFactory;

/**
 * @extends PersistentObjectFactory<TypeTaxe>
 */
final class TypeTaxeFactory extends PersistentObjectFactory
{
    #[\Override]
    public static function class(): string
    {
        return TypeTaxe::class;
    }

    /**
     * @see https://symfony.com/bundles/ZenstruckFoundryBundle/current/index.html#model-factories
     *
     */
    #[\Override]
    protected function defaults(): array|callable
    {
        return [
            'code' => self::faker()->text(5),
            'label' => self::faker()->text(255),
        ];
    }

    /**
     * @see https://symfony.com/bundles/ZenstruckFoundryBundle/current/index.html#initialization
     */
    #[\Override]
    protected function initialize(): static
    {
        return $this
            // ->afterInstantiate(function(TypeTaxe $typeTaxe): void {})
        ;
    }
}
