<?php

namespace App\Factory;

use App\Entity\Commune;
use Zenstruck\Foundry\Persistence\PersistentObjectFactory;

/**
 * @extends PersistentObjectFactory<Commune>
 */
final class CommuneFactory extends PersistentObjectFactory
{
    #[\Override]
    public static function class(): string
    {
        return Commune::class;
    }

    /**
     * @see https://symfony.com/bundles/ZenstruckFoundryBundle/current/index.html#model-factories
     *
     */
    #[\Override]
    protected function defaults(): array|callable
    {
        return [
            'code' => self::faker()->randomNumber(),
            'departement' => DepartementFactory::new(),
            'nom' => self::faker()->text(255),
        ];
    }

    /**
     * @see https://symfony.com/bundles/ZenstruckFoundryBundle/current/index.html#initialization
     */
    #[\Override]
    protected function initialize(): static
    {
        return $this
            // ->afterInstantiate(function(Commune $commune): void {})
        ;
    }
}
