<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20260114152959 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('DROP SEQUENCE greeting_id_seq CASCADE');
        $this->addSql('CREATE TABLE commune (id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL, nom VARCHAR(255) NOT NULL, departement_id INT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_E2E2D1EECCF9E01E ON commune (departement_id)');
        $this->addSql('CREATE TABLE departement (id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL, code INT NOT NULL, region_id INT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_C1765B6398260155 ON departement (region_id)');
        $this->addSql('CREATE TABLE region (id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL, nom VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE taxe (id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL, annee INT NOT NULL, taux DOUBLE PRECISION NOT NULL, volume DOUBLE PRECISION NOT NULL, commune_id INT NOT NULL, type_id INT NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_56322FE9131A4F72 ON taxe (commune_id)');
        $this->addSql('CREATE INDEX IDX_56322FE9C54C8C93 ON taxe (type_id)');
        $this->addSql('CREATE TABLE type_taxe (id INT GENERATED BY DEFAULT AS IDENTITY NOT NULL, code VARCHAR(5) NOT NULL, label VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('ALTER TABLE commune ADD CONSTRAINT FK_E2E2D1EECCF9E01E FOREIGN KEY (departement_id) REFERENCES departement (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE departement ADD CONSTRAINT FK_C1765B6398260155 FOREIGN KEY (region_id) REFERENCES region (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE taxe ADD CONSTRAINT FK_56322FE9131A4F72 FOREIGN KEY (commune_id) REFERENCES commune (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE taxe ADD CONSTRAINT FK_56322FE9C54C8C93 FOREIGN KEY (type_id) REFERENCES type_taxe (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('DROP TABLE greeting');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE SEQUENCE greeting_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE TABLE greeting (id INT NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('ALTER TABLE commune DROP CONSTRAINT FK_E2E2D1EECCF9E01E');
        $this->addSql('ALTER TABLE departement DROP CONSTRAINT FK_C1765B6398260155');
        $this->addSql('ALTER TABLE taxe DROP CONSTRAINT FK_56322FE9131A4F72');
        $this->addSql('ALTER TABLE taxe DROP CONSTRAINT FK_56322FE9C54C8C93');
        $this->addSql('DROP TABLE commune');
        $this->addSql('DROP TABLE departement');
        $this->addSql('DROP TABLE region');
        $this->addSql('DROP TABLE taxe');
        $this->addSql('DROP TABLE type_taxe');
    }
}
